//----------------------------------------------------------------------------
//
// Copyright (C) Sartorius Stedim Data Analytics AB 2017 -
//
// Use, modification and distribution are subject to the Boost Software
// License, Version 1.0. (See http://www.boost.org/LICENSE_1_0.txt)
//
//----------------------------------------------------------------------------

#ifdef _WIN32
#include "StdAfx.h"
#include <io.h>
#include <tchar.h>
#endif
#ifdef __unix__
#include <unistd.h>
#include <stdio.h>
#endif
#include <stdlib.h>
#include <limits.h>
#include "utf8util.h"
#include "sqrunner.h"

//
// main
//
#ifdef _WIN32

void usage(TCHAR* apparg)
{
   _ftprintf(stderr, _T("\n%s: Usage:\n\n")
      _T(".\\SQPCSample.exe [-plugin] <USP file>\n\n")
      _T("    -plugin --- Allow to run python plugins\n\n")
      _T("    USP file --- is a SIMCA project file\n\n"), apparg);
}

int _tmain(int argc, TCHAR* argv[], TCHAR* /*envp[]*/)
{
   char* utf8Arg;
   int allow_python_plugin = 0;
   int usp_arg = 1;

   SQRunner oSQRunner;

   if (argc == 1)
   {
      usage(argv[0]);
      return -1;
   }

   if (_tcscmp(_T("-plugin"), argv[usp_arg]) == 0)
   {
      usp_arg++;
      allow_python_plugin = 1;
   }
   if (argc <= usp_arg)
   {
      usage(argv[0]);
      return -1;
   }
   if (_taccess(argv[usp_arg], 04) != 0)
   {
      _ftprintf(stderr, _T("\n%s: Could not open: %s\n")
         _T("Make sure that the file is not missing, is a SIMCA project ")
         _T("and is readable for your user\n\n"), argv[0], argv[usp_arg]);
      return -1;
   }

   /* Convert the UTF-16 argument to UTF-8 */
   utf8Arg = TCHARtoUTF8(argv[1]);

   SQRunner_Init(&oSQRunner, utf8Arg);
   oSQRunner.mbAllowPythonPlugin = allow_python_plugin;
   SQRunner_Run(&oSQRunner);
   SQRunner_Destroy(&oSQRunner);

   free(utf8Arg);

   return 0;
}

#else

void usage(char* apparg)
{
   printf("%s: Usage:\nsqp [-plugin] <USP file>\n"
      "USP file is a SIMCA project file\n", apparg);
}

int main(int argc, char* argv[], char* envp[])
{
   SQRunner oSQRunner;

   if (argc == 1)
   {
      usage(argv[0]);
      return -1;
   }

   if (access(argv[1], 04) != 0)
   {
      printf("%s: Could not open: %s\n"
         "Make sure that the file is not missing, is a SIMCA project "
         "and is readable for your user\n", argv[0], argv[1]);
      return -1;
   }

   SQRunner_Init(&oSQRunner, argv[1]);
   SQRunner_Run(&oSQRunner);
   SQRunner_Destroy(&oSQRunner);

   return 0;
}

#endif
